(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?module.exports=factory():typeof define==="function"&&define.amd?define(factory):(global=global||self,global.Muuri=factory())})(this,function(){"use strict";var namespace="Muuri";var gridInstances={};var actionSwap="swap";var actionMove="move";var eventSynchronize="synchronize";var eventLayoutStart="layoutStart";var eventLayoutEnd="layoutEnd";var eventAdd="add";var eventRemove="remove";var eventShowStart="showStart";var eventShowEnd="showEnd";var eventHideStart="hideStart";var eventHideEnd="hideEnd";var eventFilter="filter";var eventSort="sort";var eventMove="move";var eventSend="send";var eventBeforeSend="beforeSend";var eventReceive="receive";var eventBeforeReceive="beforeReceive";var eventDragInit="dragInit";var eventDragStart="dragStart";var eventDragMove="dragMove";var eventDragScroll="dragScroll";var eventDragEnd="dragEnd";var eventDragReleaseStart="dragReleaseStart";var eventDragReleaseEnd="dragReleaseEnd";var eventDestroy="destroy";function Emitter(){this._events={};this._queue=[];this._counter=0;this._isDestroyed=false}Emitter.prototype.on=function(event,listener){if(this._isDestroyed)return this;var listeners=this._events[event];if(!listeners)listeners=this._events[event]=[];listeners.push(listener);return this};Emitter.prototype.off=function(event,listener){if(this._isDestroyed)return this;var listeners=this._events[event];if(!listeners||!listeners.length)return this;if(!listener){listeners.length=0;return this}var i=listeners.length;while(i--){if(listener===listeners[i])listeners.splice(i,1)}return this};Emitter.prototype.emit=function(event,arg1,arg2,arg3){if(this._isDestroyed)return this;var listeners=this._events[event];if(!listeners||!listeners.length)return this;var queue=this._queue;var qLength=queue.length;var aLength=arguments.length-1;var i;for(i=0;i<listeners.length;i++){queue.push(listeners[i])}++this._counter;for(i=qLength,qLength=queue.length;i<qLength;i++){aLength===0?queue[i]():aLength===1?queue[i](arg1):aLength===2?queue[i](arg1,arg2):queue[i](arg1,arg2,arg3);if(this._isDestroyed)return this}--this._counter;if(!this._counter)queue.length=0;return this};Emitter.prototype.destroy=function(){if(this._isDestroyed)return this;var events=this._events;var event;this._isDestroyed=true;this._queue.length=this._counter=0;for(event in events){if(events[event]){events[event].length=0;events[event]=undefined}}return this};var transformStyle="transform";var transformProp="transform";var docElemStyle=window.document.documentElement.style;var style="transform";var styleCap="Transform";var found=false;["","Webkit","Moz","O","ms"].forEach(function(prefix){if(found)return;var propName=prefix?prefix+styleCap:style;if(docElemStyle[propName]!==undefined){prefix=prefix.toLowerCase();transformStyle=prefix?"-"+prefix+"-"+style:style;transformProp=propName;found=true}});var stylesCache=typeof WeakMap==="function"?new WeakMap:null;function getStyle(element,style){var styles=stylesCache&&stylesCache.get(element);if(!styles){styles=window.getComputedStyle(element,null);if(stylesCache)stylesCache.set(element,styles)}return styles.getPropertyValue(style==="transform"?transformStyle:style)}var styleNameRegEx=/([A-Z])/g;function getStyleName(string){return string.replace(styleNameRegEx,"-$1").toLowerCase()}var strFunction="function";function isFunction(val){return typeof val===strFunction}var transformStyle$1="transform";function setStyles(element,styles){for(var prop in styles){element.style[prop===transformStyle$1?transformProp:prop]=styles[prop]}}function ItemAnimate(element){this._element=element;this._animation=null;this._callback=null;this._props=[];this._values=[];this._keyframes=[];this._options={};this._isDestroyed=false;this._onFinish=this._onFinish.bind(this)}ItemAnimate.prototype.start=function(propsFrom,propsTo,options){if(this._isDestroyed)return;var animation=this._animation;var currentProps=this._props;var currentValues=this._values;var opts=options||0;var cancelAnimation=false;if(animation){var propCount=0;var propIndex;for(var propName in propsTo){++propCount;propIndex=currentProps.indexOf(propName);if(propIndex===-1||propsTo[propName]!==currentValues[propIndex]){cancelAnimation=true;break}}if(!cancelAnimation&&propCount!==currentProps.length){cancelAnimation=true}}if(cancelAnimation)animation.cancel();this._callback=isFunction(opts.onFinish)?opts.onFinish:null;if(animation&&!cancelAnimation)return;currentProps.length=currentValues.length=0;for(propName in propsTo){currentProps.push(propName);currentValues.push(propsTo[propName])}var animKeyframes=this._keyframes;animKeyframes[0]=propsFrom;animKeyframes[1]=propsTo;var animOptions=this._options;animOptions.duration=opts.duration||300;animOptions.easing=opts.easing||"ease";var element=this._element;animation=element.animate(animKeyframes,animOptions);animation.onfinish=this._onFinish;this._animation=animation;setStyles(element,propsTo)};ItemAnimate.prototype.stop=function(styles){if(this._isDestroyed||!this._animation)return;var element=this._element;var currentProps=this._props;var currentValues=this._values;var propName;var propValue;var i;if(!styles){for(i=0;i<currentProps.length;i++){propName=currentProps[i];propValue=getStyle(element,getStyleName(propName));element.style[propName==="transform"?transformProp:propName]=propValue}}else{setStyles(element,styles)}this._animation.cancel();this._animation=this._callback=null;currentProps.length=currentValues.length=0};ItemAnimate.prototype.isAnimating=function(){return!!this._animation};ItemAnimate.prototype.destroy=function(){if(this._isDestroyed)return;this.stop();this._element=this._options=this._keyframes=null;this._isDestroyed=true};ItemAnimate.prototype._onFinish=function(){var callback=this._callback;this._animation=this._callback=null;this._props.length=this._values.length=0;callback&&callback()};var vendorPrefixes=["","webkit","moz","ms","o","Webkit","Moz","MS","O"];function getPrefixedPropName(elemStyle,propName){var camelPropName=propName[0].toUpperCase()+propName.slice(1);var i=0;var prefix;var prefixedPropName;while(i<vendorPrefixes.length){prefix=vendorPrefixes[i];prefixedPropName=prefix?prefix+camelPropName:propName;if(prefixedPropName in elemStyle)return prefixedPropName;++i}return null}var dt=1e3/60;var raf=(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.msRequestAnimationFrame||function(callback){return this.setTimeout(function(){callback(dt)},dt)}).bind(window);var isPassiveEventsSupported=false;try{var passiveOpts=Object.defineProperty({},"passive",{get:function(){isPassiveEventsSupported=true}});window.addEventListener("testPassive",null,passiveOpts);window.removeEventListener("testPassive",null,passiveOpts)}catch(e){}var events={start:"start",move:"move",end:"end",cancel:"cancel"};var hasTouchEvents=!!("ontouchstart"in window||window.TouchEvent);var hasPointerEvents=!!window.PointerEvent;var hasMsPointerEvents=!!window.navigator.msPointerEnabled;var isAndroid=/(android)/i.test(window.navigator.userAgent);var listenerOptions=isPassiveEventsSupported?{passive:true}:false;var taProp="touchAction";var taPropPrefixed=getPrefixedPropName(window.document.documentElement.style,taProp);var taDefaultValue="auto";function Dragger(element,cssProps){this._element=element;this._emitter=new Emitter;this._isDestroyed=false;this._cssProps={};this._touchAction="";this._startEvent=null;this._pointerId=null;this._startTime=0;this._startX=0;this._startY=0;this._currentX=0;this._currentY=0;this._preStartCheck=this._preStartCheck.bind(this);this._abortNonCancelable=this._abortNonCancelable.bind(this);this._onStart=this._onStart.bind(this);this._onMove=this._onMove.bind(this);this._onCancel=this._onCancel.bind(this);this._onEnd=this._onEnd.bind(this);this.setCssProps(cssProps);if(!this._touchAction){this.setTouchAction(taDefaultValue)}element.addEventListener("dragstart",Dragger._preventDefault,false);element.addEventListener(Dragger._events.start,this._preStartCheck,listenerOptions);if(hasTouchEvents&&!hasPointerEvents&&!hasMsPointerEvents){element.addEventListener(Dragger._mouseEvents.start,this._preStartCheck,listenerOptions)}}Dragger._pointerEvents={start:"pointerdown",move:"pointermove",cancel:"pointercancel",end:"pointerup"};Dragger._msPointerEvents={start:"MSPointerDown",move:"MSPointerMove",cancel:"MSPointerCancel",end:"MSPointerUp"};Dragger._touchEvents={start:"touchstart",move:"touchmove",cancel:"touchcancel",end:"touchend"};Dragger._mouseEvents={start:"mousedown",move:"mousemove",cancel:"",end:"mouseup"};Dragger._events=function(){if(hasPointerEvents)return Dragger._pointerEvents;if(hasMsPointerEvents)return Dragger._msPointerEvents;if(hasTouchEvents)return Dragger._touchEvents;return Dragger._mouseEvents}();Dragger._emitter=new Emitter;Dragger._activeInstances=[];Dragger._preventDefault=function(e){if(e.preventDefault&&e.cancelable!==false)e.preventDefault()};Dragger._activateInstance=function(instance){var index=Dragger._activeInstances.indexOf(instance);if(index>-1)return;Dragger._activeInstances.push(instance);Dragger._emitter.on(events.move,instance._onMove);Dragger._emitter.on(events.cancel,instance._onCancel);Dragger._emitter.on(events.end,instance._onEnd);if(Dragger._activeInstances.length===1){Dragger._bindListeners()}};Dragger._deactivateInstance=function(instance){var index=Dragger._activeInstances.indexOf(instance);if(index===-1)return;Dragger._activeInstances.splice(index,1);Dragger._emitter.off(events.move,instance._onMove);Dragger._emitter.off(events.cancel,instance._onCancel);Dragger._emitter.off(events.end,instance._onEnd);if(!Dragger._activeInstances.length){Dragger._unbindListeners()}};Dragger._bindListeners=function(){var events=Dragger._events;window.addEventListener(events.move,Dragger._onMove,listenerOptions);window.addEventListener(events.end,Dragger._onEnd,listenerOptions);events.cancel&&window.addEventListener(events.cancel,Dragger._onCancel,listenerOptions)};Dragger._unbindListeners=function(){var events=Dragger._events;window.removeEventListener(events.move,Dragger._onMove,listenerOptions);window.removeEventListener(events.end,Dragger._onEnd,listenerOptions);events.cancel&&window.removeEventListener(events.cancel,Dragger._onCancel,listenerOptions)};Dragger._getEventPointerId=function(event){if(typeof event.pointerId==="number"){return event.pointerId}if(event.changedTouches){return event.changedTouches[0]?event.changedTouches[0].identifier:null}return 1};Dragger._getTouchById=function(event,id){if(typeof event.pointerId==="number"){return event.pointerId===id?event:null}if(event.changedTouches){for(var i=0;i<event.changedTouches.length;i++){if(event.changedTouches[i].identifier===id){return event.changedTouches[i]}}return null}return event};Dragger._onMove=function(e){Dragger._emitter.emit(events.move,e)};Dragger._onCancel=function(e){Dragger._emitter.emit(events.cancel,e)};Dragger._onEnd=function(e){Dragger._emitter.emit(events.end,e)};Dragger.prototype._reset=function(){if(this._isDestroyed)return;this._pointerId=null;this._startTime=0;this._startX=0;this._startY=0;this._currentX=0;this._currentY=0;this._startEvent=null;this._element.removeEventListener(Dragger._touchEvents.start,this._abortNonCancelable,listenerOptions);Dragger._deactivateInstance(this)};Dragger.prototype._createEvent=function(type,e){var touch=this._getTrackedTouch(e);return{type:type,srcEvent:e,distance:this.getDistance(),deltaX:this.getDeltaX(),deltaY:this.getDeltaY(),deltaTime:type===events.start?0:this.getDeltaTime(),isFirst:type===events.start,isFinal:type===events.end||type===events.cancel,identifier:this._pointerId,screenX:touch.screenX,screenY:touch.screenY,clientX:touch.clientX,clientY:touch.clientY,pageX:touch.pageX,pageY:touch.pageY,target:touch.target}};Dragger.prototype._emit=function(type,e){this._emitter.emit(type,this._createEvent(type,e))};Dragger.prototype._getTrackedTouch=function(e){if(this._pointerId===null){return null}else{return Dragger._getTouchById(e,this._pointerId)}};Dragger.prototype._preStartCheck=function(e){if(this._isDestroyed)return;if(this.isDragging())return;if(isAndroid&&e.cancelable===false)return;if(e.button)return;this._pointerId=Dragger._getEventPointerId(e);if(this._pointerId===null)return;this._startEvent=e;if(hasTouchEvents&&(hasPointerEvents||hasMsPointerEvents)){if(isAndroid){this._element.addEventListener(Dragger._touchEvents.start,this._abortNonCancelable,listenerOptions)}raf(this._onStart)}else{this._onStart()}};Dragger.prototype._abortNonCancelable=function(e){this._element.removeEventListener(Dragger._touchEvents.start,this._abortNonCancelable,listenerOptions);if(this._startEvent&&e.cancelable===false){this._pointerId=null;this._startEvent=null}};Dragger.prototype._onStart=function(){var e=this._startEvent;if(!e)return;this._startEvent=null;var touch=this._getTrackedTouch(e);if(!touch)return;this._startX=this._currentX=touch.clientX;this._startY=this._currentY=touch.clientY;this._startTime=Date.now();this._emit(events.start,e);Dragger._activateInstance(this)};Dragger.prototype._onMove=function(e){var touch=this._getTrackedTouch(e);if(!touch)return;this._currentX=touch.clientX;this._currentY=touch.clientY;this._emit(events.move,e)};Dragger.prototype._onCancel=function(e){if(!this._getTrackedTouch(e))return;this._emit(events.cancel,e);this._reset()};Dragger.prototype._onEnd=function(e){if(!this._getTrackedTouch(e))return;this._emit(events.end,e);this._reset()};Dragger.prototype.isDragging=function(){return this._pointerId!==null};Dragger.prototype.setTouchAction=function(value){this._touchAction=value;if(taPropPrefixed){this._cssProps[taPropPrefixed]="";this._element.style[taPropPrefixed]=value}if(hasTouchEvents){this._element.removeEventListener(Dragger._touchEvents.start,Dragger._preventDefault,false);if(this._element.style[taPropPrefixed]!==value){this._element.addEventListener(Dragger._touchEvents.start,Dragger._preventDefault,false)}}};Dragger.prototype.setCssProps=function(newProps){if(!newProps)return;var currentProps=this._cssProps;var element=this._element;var prop;var prefixedProp;for(prop in currentProps){element.style[prop]=currentProps[prop];delete currentProps[prop]}for(prop in newProps){if(!newProps[prop])continue;if(prop===taProp){this.setTouchAction(newProps[prop]);continue}prefixedProp=getPrefixedPropName(element.style,prop);if(!prefixedProp)continue;currentProps[prefixedProp]="";element.style[prefixedProp]=newProps[prop]}};Dragger.prototype.getDeltaX=function(){return this._currentX-this._startX};Dragger.prototype.getDeltaY=function(){return this._currentY-this._startY};Dragger.prototype.getDistance=function(){var x=this.getDeltaX();var y=this.getDeltaY();return Math.sqrt(x*x+y*y)};Dragger.prototype.getDeltaTime=function(){return this._startTime?Date.now()-this._startTime:0};Dragger.prototype.on=function(eventName,listener){this._emitter.on(eventName,listener)};Dragger.prototype.off=function(events,listener){this._emitter.off(eventName,listener)};Dragger.prototype.destroy=function(){if(this._isDestroyed)return;var element=this._element;var events=Dragger._events;this._reset();this._emitter.destroy();element.removeEventListener(events.start,this._preStartCheck,listenerOptions);element.removeEventListener(Dragger._mouseEvents.start,this._preStartCheck,listenerOptions);element.removeEventListener("dragstart",Dragger._preventDefault,false);element.removeEventListener(Dragger._touchEvents.start,Dragger._preventDefault,false);for(var prop in this._cssProps){element.style[prop]=this._cssProps[prop];delete this._cssProps[prop]}this._element=null;this._isDestroyed=true};function Ticker(){this._nextStep=null;this._queue=[];this._reads={};this._writes={};this._batch=[];this._batchReads={};this._batchWrites={};this._step=this._step.bind(this)}Ticker.prototype.add=function(id,readOperation,writeOperation,isPrioritized){var currentIndex=this._queue.indexOf(id);if(currentIndex>-1)this._queue[currentIndex]=undefined;isPrioritized?this._queue.unshift(id):this._queue.push(id);this._reads[id]=readOperation;this._writes[id]=writeOperation;if(!this._nextStep)this._nextStep=raf(this._step)};Ticker.prototype.cancel=function(id){var currentIndex=this._queue.indexOf(id);if(currentIndex>-1){this._queue[currentIndex]=undefined;delete this._reads[id];delete this._writes[id]}};Ticker.prototype._step=function(){var queue=this._queue;var reads=this._reads;var writes=this._writes;var batch=this._batch;var batchReads=this._batchReads;var batchWrites=this._batchWrites;var length=queue.length;var id;var i;this._nextStep=null;for(i=0;i<length;i++){id=queue[i];if(!id)continue;batch.push(id);batchReads[id]=reads[id];delete reads[id];batchWrites[id]=writes[id];delete writes[id]}queue.length=0;for(i=0;i<length;i++){id=batch[i];if(batchReads[id]){batchReads[id]();delete batchReads[id]}}for(i=0;i<length;i++){id=batch[i];if(batchWrites[id]){batchWrites[id]();delete batchWrites[id]}}batch.length=0;if(!this._nextStep&&queue.length){this._nextStep=raf(this._step)}};var ticker=new Ticker;var layoutTick="layout";var visibilityTick="visibility";var moveTick="move";var scrollTick="scroll";var placeholderTick="placeholder";function addLayoutTick(itemId,readCallback,writeCallback){return ticker.add(itemId+layoutTick,readCallback,writeCallback)}function cancelLayoutTick(itemId){return ticker.cancel(itemId+layoutTick)}function addVisibilityTick(itemId,readCallback,writeCallback){return ticker.add(itemId+visibilityTick,readCallback,writeCallback)}function cancelVisibilityTick(itemId){return ticker.cancel(itemId+visibilityTick)}function addMoveTick(itemId,readCallback,writeCallback){return ticker.add(itemId+moveTick,readCallback,writeCallback,true)}function cancelMoveTick(itemId){return ticker.cancel(itemId+moveTick)}function addScrollTick(itemId,readCallback,writeCallback){return ticker.add(itemId+scrollTick,readCallback,writeCallback,true)}function cancelScrollTick(itemId){return ticker.cancel(itemId+scrollTick)}function addPlaceholderTick(itemId,readCallback,writeCallback){return ticker.add(itemId+placeholderTick,readCallback,writeCallback)}function cancelPlaceholderTick(itemId){return ticker.cancel(itemId+placeholderTick)}var ElProto=window.Element.prototype;var matchesFn=ElProto.matches||ElProto.matchesSelector||ElProto.webkitMatchesSelector||ElProto.mozMatchesSelector||ElProto.msMatchesSelector||ElProto.oMatchesSelector||function(){return false};function elementMatches(el,selector){return matchesFn.call(el,selector)}function addClass(element,className){if(element.classList){element.classList.add(className)}else{if(!elementMatches(element,"."+className)){element.className+=" "+className}}}var tempArray=[];var numberType="number";function arrayInsert(array,items,index){var startIndex=typeof index===numberType?index:-1;if(startIndex<0)startIndex=array.length-startIndex+1;array.splice.apply(array,tempArray.concat(startIndex,0,items));tempArray.length=0}function normalizeArrayIndex(array,index,isMigration){var length=array.length;var maxIndex=Math.max(0,isMigration?length:length-1);return index>maxIndex?maxIndex:index<0?Math.max(maxIndex+index+1,0):index}function arrayMove(array,fromIndex,toIndex){if(array.length<2)return;var from=normalizeArrayIndex(array,fromIndex);var to=normalizeArrayIndex(array,toIndex);if(from!==to){array.splice(to,0,array.splice(from,1)[0])}}function arraySwap(array,index,withIndex){if(array.length<2)return;var indexA=normalizeArrayIndex(array,index);var indexB=normalizeArrayIndex(array,withIndex);var temp;if(indexA!==indexB){temp=array[indexA];array[indexA]=array[indexB];array[indexB]=temp}}var actionCancel="cancel";var actionFinish="finish";var debounceTick="debounce";var debounceId=0;function debounce(fn,wait){var timeout;var tickerId=++debounceId+debounceTick;if(wait>0){return function(action){if(timeout!==undefined){timeout=window.clearTimeout(timeout);ticker.cancel(tickerId);if(action===actionFinish)fn()}if(action!==actionCancel&&action!==actionFinish){timeout=window.setTimeout(function(){timeout=undefined;ticker.add(tickerId,fn,null,true)},wait)}}}return function(action){if(action!==actionCancel)fn()}}function isTransformed(element){var transform=getStyle(element,"transform");if(!transform||transform==="none")return false;var display=getStyle(element,"display");if(display==="inline"||display==="none")return false;return true}function getContainingBlock(element,includeSelf){var document=window.document;var ret=(includeSelf?element:element.parentElement)||document;while(ret&&ret!==document&&getStyle(ret,"position")==="static"&&!isTransformed(ret)){ret=ret.parentElement||document}return ret}function getStyleAsFloat(el,style){return parseFloat(getStyle(el,style))||0}var offsetA={};var offsetB={};var offsetDiff={};function getOffset(element,offsetData){var ret=offsetData||{};var rect;ret.left=0;ret.top=0;if(element===document)return ret;ret.left=window.pageXOffset||0;ret.top=window.pageYOffset||0;if(element.self===window.self)return ret;rect=element.getBoundingClientRect();ret.left+=rect.left;ret.top+=rect.top;ret.left+=getStyleAsFloat(element,"border-left-width");ret.top+=getStyleAsFloat(element,"border-top-width");return ret}function getOffsetDiff(elemA,elemB,compareContainingBlocks){offsetDiff.left=0;offsetDiff.top=0;if(elemA===elemB)return offsetDiff;if(compareContainingBlocks){elemA=getContainingBlock(elemA,true);elemB=getContainingBlock(elemB,true);if(elemA===elemB)return offsetDiff}getOffset(elemA,offsetA);getOffset(elemB,offsetB);offsetDiff.left=offsetB.left-offsetA.left;offsetDiff.top=offsetB.top-offsetA.top;return offsetDiff}var styleOverflow="overflow";var styleOverflowX="overflow-x";var styleOverflowY="overflow-y";var overflowAuto="auto";var overflowScroll="scroll";function isScrollable(element){var overflow=getStyle(element,styleOverflow);if(overflow===overflowAuto||overflow===overflowScroll)return true;overflow=getStyle(element,styleOverflowX);if(overflow===overflowAuto||overflow===overflowScroll)return true;overflow=getStyle(element,styleOverflowY);if(overflow===overflowAuto||overflow===overflowScroll)return true;return false}function getScrollableAncestors(element,includeSelf,data){var ret=data||[];var parent=includeSelf?element:element.parentNode;while(parent&&parent!==document){if(parent.getRootNode&&parent instanceof DocumentFragment){parent=parent.getRootNode().host;continue}if(isScrollable(parent)){ret.push(parent)}parent=parent.parentNode}ret.push(window);return ret}var translateValue={};var transformStyle$2="transform";var transformNone="none";var rxMat3d=/^matrix3d/;var rxMatTx=/([^,]*,){4}/;var rxMat3dTx=/([^,]*,){12}/;var rxNextItem=/[^,]*,/;function getTranslate(element){translateValue.x=0;translateValue.y=0;var transform=getStyle(element,transformStyle$2);if(!transform||transform===transformNone){return translateValue}var isMat3d=rxMat3d.test(transform);var tX=transform.replace(isMat3d?rxMat3dTx:rxMatTx,"");var tY=tX.replace(rxNextItem,"");translateValue.x=parseFloat(tX)||0;translateValue.y=parseFloat(tY)||0;return translateValue}function getTranslateString(x,y){return"translateX("+x+"px) translateY("+y+"px)"}function removeClass(element,className){if(element.classList){element.classList.remove(className)}else{if(elementMatches(element,"."+className)){element.className=(" "+element.className+" ").replace(" "+className+" "," ").trim()}}}var startPredicateInactive=0;var startPredicatePending=1;var startPredicateResolved=2;var startPredicateRejected=3;function ItemDrag(item){var element=item._element;var grid=item.getGrid();var settings=grid._settings;this._item=item;this._gridId=grid._id;this._isDestroyed=false;this._isMigrating=false;this._startPredicate=isFunction(settings.dragStartPredicate)?settings.dragStartPredicate:ItemDrag.defaultStartPredicate;this._startPredicateState=startPredicateInactive;this._startPredicateResult=undefined;this._hBlockedIndex=null;this._hX1=0;this._hX2=0;this._hY1=0;this._hY2=0;this._reset();this._preStartCheck=this._preStartCheck.bind(this);this._preEndCheck=this._preEndCheck.bind(this);this._onScroll=this._onScroll.bind(this);this._prepareMove=this._prepareMove.bind(this);this._applyMove=this._applyMove.bind(this);this._prepareScroll=this._prepareScroll.bind(this);this._applyScroll=this._applyScroll.bind(this);this._checkOverlap=this._checkOverlap.bind(this);var sortInterval=settings.dragSortHeuristics.sortInterval;this._checkOverlapDebounce=debounce(this._checkOverlap,sortInterval);this._dragger=new Dragger(element,settings.dragCssProps);this._dragger.on("start",this._preStartCheck);this._dragger.on("move",this._preStartCheck);this._dragger.on("cancel",this._preEndCheck);this._dragger.on("end",this._preEndCheck)}ItemDrag.defaultStartPredicate=function(item,event,options){var drag=item._drag;var predicate=drag._startPredicateData||drag._setupStartPredicate(options);if(event.isFinal){drag._finishStartPredicate(event);return}if(!predicate.handleElement){predicate.handleElement=drag._getStartPredicateHandle(event);if(!predicate.handleElement)return false}if(predicate.delay){predicate.event=event;if(!predicate.delayTimer){predicate.delayTimer=window.setTimeout(function(){predicate.delay=0;if(drag._resolveStartPredicate(predicate.event)){drag._forceResolveStartPredicate(predicate.event);drag._resetStartPredicate()}},predicate.delay)}}return drag._resolveStartPredicate(event)};ItemDrag.defaultSortPredicate=function(){var itemRect={};var targetRect={};var returnData={};var rootGridArray=[];function getTargetGrid(item,rootGrid,threshold){var target=null;var dragSort=rootGrid._settings.dragSort;var bestScore=-1;var gridScore;var grids;var grid;var i;if(dragSort===true){rootGridArray[0]=rootGrid;grids=rootGridArray}else{grids=dragSort.call(rootGrid,item)}if(!Array.isArray(grids))return target;for(i=0;i<grids.length;i++){grid=grids[i];if(grid._isDestroyed)continue;grid._updateBoundingRect();targetRect.width=grid._width;targetRect.height=grid._height;targetRect.left=grid._left;targetRect.top=grid._top;gridScore=getRectOverlapScore(itemRect,targetRect);if(gridScore>threshold&&gridScore>bestScore){bestScore=gridScore;target=grid}}rootGridArray.length=0;return target}return function(item,options){var drag=item._drag;var rootGrid=drag._getGrid();var sortThreshold=options&&typeof options.threshold==="number"?options.threshold:50;var sortAction=options&&options.action===actionSwap?actionSwap:actionMove;itemRect.width=item._width;itemRect.height=item._height;itemRect.left=drag._elementClientX;itemRect.top=drag._elementClientY;var grid=getTargetGrid(item,rootGrid,sortThreshold);if(!grid)return false;var gridOffsetLeft=0;var gridOffsetTop=0;var matchScore=-1;var matchIndex;var hasValidTargets;var target;var score;var i;if(grid===rootGrid){itemRect.left=drag._gridX+item._marginLeft;itemRect.top=drag._gridY+item._marginTop}else{grid._updateBorders(1,0,1,0);gridOffsetLeft=grid._left+grid._borderLeft;gridOffsetTop=grid._top+grid._borderTop}for(i=0;i<grid._items.length;i++){target=grid._items[i];if(!target._isActive||target===item){continue}hasValidTargets=true;targetRect.width=target._width;targetRect.height=target._height;targetRect.left=target._left+target._marginLeft+gridOffsetLeft;targetRect.top=target._top+target._marginTop+gridOffsetTop;score=getRectOverlapScore(itemRect,targetRect);if(score>matchScore){matchIndex=i;matchScore=score}}if(matchScore<sortThreshold&&item.getGrid()!==grid){matchIndex=hasValidTargets?-1:0;matchScore=Infinity}if(matchScore>=sortThreshold){returnData.grid=grid;returnData.index=matchIndex;returnData.action=sortAction;return returnData}return false}}();ItemDrag.prototype.stop=function(){var item=this._item;var element=item._element;var grid=this._getGrid();if(!this._isActive)return this;if(this._isMigrating){this._finishMigration();return this}cancelMoveTick(item._id);cancelScrollTick(item._id);this._unbindScrollListeners();this._checkOverlapDebounce("cancel");if(element.parentNode!==grid._element){grid._element.appendChild(element);element.style[transformProp]=getTranslateString(this._gridX,this._gridY)}removeClass(element,grid._settings.itemDraggingClass);this._reset();return this};ItemDrag.prototype.destroy=function(){if(this._isDestroyed)return this;this.stop();this._dragger.destroy();this._isDestroyed=true;return this};ItemDrag.prototype._getGrid=function(){return gridInstances[this._gridId]||null};ItemDrag.prototype._reset=function(){this._isActive=false;this._container=null;this._containingBlock=null;this._dragEvent=null;this._scrollEvent=null;this._scrollers=[];this._left=0;this._top=0;this._gridX=0;this._gridY=0;this._elementClientX=0;this._elementClientY=0;this._containerDiffX=0;this._containerDiffY=0};ItemDrag.prototype._bindScrollListeners=function(){var gridContainer=this._getGrid()._element;var dragContainer=this._container;var scrollers=this._scrollers;var gridScrollers;var i;scrollers.length=0;getScrollableAncestors(this._item._element,false,scrollers);if(dragContainer!==gridContainer){gridScrollers=[];getScrollableAncestors(gridContainer,true,gridScrollers);for(i=0;i<gridScrollers.length;i++){if(scrollers.indexOf(gridScrollers[i])<0){scrollers.push(gridScrollers[i])}}}for(i=0;i<scrollers.length;i++){scrollers[i].addEventListener("scroll",this._onScroll)}};ItemDrag.prototype._unbindScrollListeners=function(){var scrollers=this._scrollers;var i;for(i=0;i<scrollers.length;i++){scrollers[i].removeEventListener("scroll",this._onScroll)}scrollers.length=0};ItemDrag.prototype._setupStartPredicate=function(options){var config=options||this._getGrid()._settings.dragStartPredicate||0;return this._startPredicateData={distance:Math.abs(config.distance)||0,delay:Math.max(config.delay,0)||0,handle:typeof config.handle==="string"?config.handle:false}};ItemDrag.prototype._getStartPredicateHandle=function(event){var predicate=this._startPredicateData;var element=this._item._element;var handleElement=element;if(!predicate.handle)return handleElement;handleElement=event.target;while(handleElement&&!elementMatches(handleElement,predicate.handle)){handleElement=handleElement!==element?handleElement.parentElement:null}return handleElement||null};ItemDrag.prototype._resolveStartPredicate=function(event){var predicate=this._startPredicateData;if(event.distance<predicate.distance||predicate.delay)return;var handleRect=predicate.handleElement.getBoundingClientRect();var handleLeft=handleRect.left+(window.pageXOffset||0);var handleTop=handleRect.top+(window.pageYOffset||0);var handleWidth=handleRect.width;var handleHeight=handleRect.height;this._resetStartPredicate();return handleWidth&&handleHeight&&event.pageX>=handleLeft&&event.pageX<handleLeft+handleWidth&&event.pageY>=handleTop&&event.pageY<handleTop+handleHeight};ItemDrag.prototype._forceResolveStartPredicate=function(event){if(!this._isDestroyed&&this._startPredicateState===startPredicatePending){this._startPredicateState=startPredicateResolved;this._onStart(event)}};ItemDrag.prototype._finishStartPredicate=function(event){var element=this._item._element;var isClick=Math.abs(event.deltaX)<2&&Math.abs(event.deltaY)<2&&event.deltaTime<200;this._resetStartPredicate();if(isClick)openAnchorHref(element)};ItemDrag.prototype._resetHeuristics=function(event){this._hBlockedIndex=null;this._hX1=this._hX2=event.clientX;this._hY1=this._hY2=event.clientY};ItemDrag.prototype._checkHeuristics=function(event){var settings=this._getGrid()._settings.dragSortHeuristics;var minDist=settings.minDragDistance;if(minDist<=0){this._hBlockedIndex=null;return true}var x=event.clientX;var y=event.clientY;var diffX=x-this._hX2;var diffY=y-this._hY2;var canCheckBounceBack=minDist>3&&settings.minBounceBackAngle>0;if(!canCheckBounceBack){this._hBlockedIndex=null}if(Math.abs(diffX)>minDist||Math.abs(diffY)>minDist){if(canCheckBounceBack){var angle=Math.atan2(diffX,diffY);var prevAngle=Math.atan2(this._hX2-this._hX1,this._hY2-this._hY1);var deltaAngle=Math.atan2(Math.sin(angle-prevAngle),Math.cos(angle-prevAngle));if(Math.abs(deltaAngle)>settings.minBounceBackAngle){this._hBlockedIndex=null}}this._hX1=this._hX2;this._hY1=this._hY2;this._hX2=x;this._hY2=y;return true}return false};ItemDrag.prototype._resetStartPredicate=function(){var predicate=this._startPredicateData;if(predicate){if(predicate.delayTimer){predicate.delayTimer=window.clearTimeout(predicate.delayTimer)}this._startPredicateData=null}};ItemDrag.prototype._checkOverlap=function(){if(!this._isActive)return;var item=this._item;var settings=this._getGrid()._settings;var result;var currentGrid;var currentIndex;var targetGrid;var targetIndex;var sortAction;var isMigration;if(isFunction(settings.dragSortPredicate)){result=settings.dragSortPredicate(item,this._dragEvent)}else{result=ItemDrag.defaultSortPredicate(item,settings.dragSortPredicate)}if(!result||typeof result.index!=="number")return;currentGrid=item.getGrid();targetGrid=result.grid||currentGrid;isMigration=currentGrid!==targetGrid;currentIndex=currentGrid._items.indexOf(item);targetIndex=normalizeArrayIndex(targetGrid._items,result.index,isMigration);sortAction=result.action===actionSwap?actionSwap:actionMove;if(!isMigration&&targetIndex===this._hBlockedIndex){return}if(!isMigration){if(currentIndex!==targetIndex){this._hBlockedIndex=currentIndex;(sortAction===actionSwap?arraySwap:arrayMove)(currentGrid._items,currentIndex,targetIndex);if(currentGrid._hasListeners(eventMove)){currentGrid._emit(eventMove,{item:item,fromIndex:currentIndex,toIndex:targetIndex,action:sortAction})}currentGrid.layout()}}else{this._hBlockedIndex=null;if(currentGrid._hasListeners(eventBeforeSend)){currentGrid._emit(eventBeforeSend,{item:item,fromGrid:currentGrid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}if(targetGrid._hasListeners(eventBeforeReceive)){targetGrid._emit(eventBeforeReceive,{item:item,fromGrid:currentGrid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}item._gridId=targetGrid._id;this._isMigrating=item._gridId!==this._gridId;currentGrid._items.splice(currentIndex,1);arrayInsert(targetGrid._items,item,targetIndex);item._sortData=null;if(currentGrid._hasListeners(eventSend)){currentGrid._emit(eventSend,{item:item,fromGrid:currentGrid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}if(targetGrid._hasListeners(eventReceive)){targetGrid._emit(eventReceive,{item:item,fromGrid:currentGrid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}currentGrid.layout();targetGrid.layout()}};ItemDrag.prototype._finishMigration=function(){var item=this._item;var release=item._release;var element=item._element;var isActive=item._isActive;var targetGrid=item.getGrid();var targetGridElement=targetGrid._element;var targetSettings=targetGrid._settings;var targetContainer=targetSettings.dragContainer||targetGridElement;var currentSettings=this._getGrid()._settings;var currentContainer=element.parentNode;var translate;var offsetDiff;this._isMigrating=false;this.destroy();removeClass(element,currentSettings.itemClass);removeClass(element,currentSettings.itemVisibleClass);removeClass(element,currentSettings.itemHiddenClass);addClass(element,targetSettings.itemClass);addClass(element,isActive?targetSettings.itemVisibleClass:targetSettings.itemHiddenClass);if(targetContainer!==currentContainer){targetContainer.appendChild(element);offsetDiff=getOffsetDiff(currentContainer,targetContainer,true);translate=getTranslate(element);translate.x-=offsetDiff.left;translate.y-=offsetDiff.top}item._refreshDimensions();item._refreshSortData();offsetDiff=getOffsetDiff(targetContainer,targetGridElement,true);release._containerDiffX=offsetDiff.left;release._containerDiffY=offsetDiff.top;item._drag=targetSettings.dragEnabled?new ItemDrag(item):null;if(targetContainer!==currentContainer){element.style[transformProp]=getTranslateString(translate.x,translate.y)}item._child.removeAttribute("style");setStyles(item._child,isActive?targetSettings.visibleStyles:targetSettings.hiddenStyles);release.start()};ItemDrag.prototype._preStartCheck=function(event){if(this._startPredicateState===startPredicateInactive){this._startPredicateState=startPredicatePending}if(this._startPredicateState===startPredicatePending){this._startPredicateResult=this._startPredicate(this._item,event);if(this._startPredicateResult===true){this._startPredicateState=startPredicateResolved;this._onStart(event)}else if(this._startPredicateResult===false){this._startPredicateState=startPredicateRejected}}else if(this._startPredicateState===startPredicateResolved&&this._isActive){this._onMove(event)}};ItemDrag.prototype._preEndCheck=function(event){var isResolved=this._startPredicateState===startPredicateResolved;this._startPredicate(this._item,event);this._startPredicateState=startPredicateInactive;if(isResolved&&this._isActive)this._onEnd(event)};ItemDrag.prototype._onStart=function(event){var item=this._item;if(!item._isActive)return;var element=item._element;var grid=this._getGrid();var settings=grid._settings;var release=item._release;var migrate=item._migrate;var gridContainer=grid._element;var dragContainer=settings.dragContainer||gridContainer;var containingBlock=getContainingBlock(dragContainer,true);var translate=getTranslate(element);var currentLeft=translate.x;var currentTop=translate.y;var elementRect=element.getBoundingClientRect();var hasDragContainer=dragContainer!==gridContainer;var offsetDiff;this._resetHeuristics(event);if(hasDragContainer){offsetDiff=getOffsetDiff(containingBlock,gridContainer)}if(item.isPositioning()){item._layout.stop(true,{transform:getTranslateString(currentLeft,currentTop)})}if(migrate._isActive){currentLeft-=migrate._containerDiffX;currentTop-=migrate._containerDiffY;migrate.stop(true,{transform:getTranslateString(currentLeft,currentTop)})}if(item.isReleasing())release._reset();this._isActive=true;this._dragEvent=event;this._container=dragContainer;this._containingBlock=containingBlock;this._elementClientX=elementRect.left;this._elementClientY=elementRect.top;this._left=this._gridX=currentLeft;this._top=this._gridY=currentTop;if(settings.dragPlaceholder.enabled){item._dragPlaceholder.create()}grid._emit(eventDragInit,item,event);if(hasDragContainer){this._containerDiffX=offsetDiff.left;this._containerDiffY=offsetDiff.top;if(element.parentNode===dragContainer){this._gridX=currentLeft-this._containerDiffX;this._gridY=currentTop-this._containerDiffY}else{this._left=currentLeft+this._containerDiffX;this._top=currentTop+this._containerDiffY;dragContainer.appendChild(element);element.style[transformProp]=getTranslateString(this._left,this._top)}}addClass(element,settings.itemDraggingClass);this._bindScrollListeners();grid._emit(eventDragStart,item,event)};ItemDrag.prototype._onMove=function(event){var item=this._item;if(!item._isActive){this.stop();return}var settings=this._getGrid()._settings;var axis=settings.dragAxis;if(axis!=="y"){var xDiff=event.clientX-this._dragEvent.clientX;this._left+=xDiff;this._gridX+=xDiff;this._elementClientX+=xDiff}if(axis!=="x"){var yDiff=event.clientY-this._dragEvent.clientY;this._top+=yDiff;this._gridY+=yDiff;this._elementClientY+=yDiff}this._dragEvent=event;addMoveTick(item._id,this._prepareMove,this._applyMove)};ItemDrag.prototype._prepareMove=function(){if(!this._item._isActive)return;if(this._getGrid()._settings.dragSort){if(this._checkHeuristics(this._dragEvent)){this._checkOverlapDebounce()}}};ItemDrag.prototype._applyMove=function(){var item=this._item;if(!item._isActive)return;item._element.style[transformProp]=getTranslateString(this._left,this._top);this._getGrid()._emit(eventDragMove,item,this._dragEvent)};ItemDrag.prototype._onScroll=function(event){var item=this._item;if(!item._isActive){this.stop();return}this._scrollEvent=event;addScrollTick(item._id,this._prepareScroll,this._applyScroll)};ItemDrag.prototype._prepareScroll=function(){var item=this._item;if(!item._isActive)return;var element=item._element;var grid=this._getGrid();var settings=grid._settings;var axis=settings.dragAxis;var gridContainer=grid._element;var offsetDiff;var rect=element.getBoundingClientRect();var xDiff=this._elementClientX-rect.left;var yDiff=this._elementClientY-rect.top;if(this._container!==gridContainer){offsetDiff=getOffsetDiff(this._containingBlock,gridContainer);this._containerDiffX=offsetDiff.left;this._containerDiffY=offsetDiff.top}if(axis!=="y"){this._left+=xDiff;this._gridX=this._left-this._containerDiffX}if(axis!=="x"){this._top+=yDiff;this._gridY=this._top-this._containerDiffY}if(settings.dragSort)this._checkOverlapDebounce()};ItemDrag.prototype._applyScroll=function(){var item=this._item;if(!item._isActive)return;item._element.style[transformProp]=getTranslateString(this._left,this._top);this._getGrid()._emit(eventDragScroll,item,this._scrollEvent)};ItemDrag.prototype._onEnd=function(event){var item=this._item;var element=item._element;var grid=this._getGrid();var settings=grid._settings;var release=item._release;if(!item._isActive){this.stop();return}cancelMoveTick(item._id);cancelScrollTick(item._id);settings.dragSort&&this._checkOverlapDebounce("finish");this._unbindScrollListeners();release._containerDiffX=this._containerDiffX;release._containerDiffY=this._containerDiffY;this._reset();removeClass(element,settings.itemDraggingClass);grid._emit(eventDragEnd,item,event);this._isMigrating?this._finishMigration():release.start()};function getRectOverlapScore(a,b){if(a.left+a.width<=b.left||b.left+b.width<=a.left||a.top+a.height<=b.top||b.top+b.height<=a.top){return 0}var width=Math.min(a.left+a.width,b.left+b.width)-Math.max(a.left,b.left);var height=Math.min(a.top+a.height,b.top+b.height)-Math.max(a.top,b.top);var maxWidth=Math.min(a.width,b.width);var maxHeight=Math.min(a.height,b.height);return width*height/(maxWidth*maxHeight)*100}function openAnchorHref(element){if(element.tagName.toLowerCase()!=="a")return;var href=element.getAttribute("href");if(!href)return;var target=element.getAttribute("target");if(target&&target!=="_self"){window.open(href,target)}else{window.location.href=href}}function ItemDragPlaceholder(item){this._item=item;this._animate=new ItemAnimate;this._element=null;this._className="";this._didMigrate=false;this._resetAfterLayout=false;this._currentLeft=0;this._currentTop=0;this._nextLeft=0;this._nextTop=0;this._setupAnimation=this._setupAnimation.bind(this);this._startAnimation=this._startAnimation.bind(this);this._onLayoutStart=this._onLayoutStart.bind(this);this._onLayoutEnd=this._onLayoutEnd.bind(this);this._onReleaseEnd=this._onReleaseEnd.bind(this);this._onMigrate=this._onMigrate.bind(this)}ItemDragPlaceholder.prototype._onLayoutStart=function(){var item=this._item;var grid=item.getGrid();var itemIndex=grid._items.indexOf(item);var nextLeft=grid._layout.slots[itemIndex*2];var nextTop=grid._layout.slots[itemIndex*2+1];if(!this._didMigrate&&item._left===nextLeft&&item._top===nextTop){return}nextLeft+=item._marginLeft;nextTop+=item._marginTop;var animEnabled=grid._settings.dragPlaceholder.duration>0;if(!animEnabled||this._didMigrate){cancelPlaceholderTick(item._id);var targetStyles={transform:getTranslateString(nextLeft,nextTop)};if(this._animate.isAnimating()){this._animate.stop(targetStyles)}else{setStyles(this._element,targetStyles)}if(this._didMigrate){grid.getElement().appendChild(this._element);this._didMigrate=false}return}this._nextLeft=nextLeft;this._nextTop=nextTop;addPlaceholderTick(item._id,this._setupAnimation,this._startAnimation)};ItemDragPlaceholder.prototype._setupAnimation=function(){if(!this.isActive())return;var translate=getTranslate(this._element);this._currentLeft=translate.x;this._currentTop=translate.y};ItemDragPlaceholder.prototype._startAnimation=function(){if(!this.isActive())return;var animation=this._animate;var currentLeft=this._currentLeft;var currentTop=this._currentTop;var nextLeft=this._nextLeft;var nextTop=this._nextTop;var targetStyles={transform:getTranslateString(nextLeft,nextTop)};if(currentLeft===nextLeft&&currentTop===nextTop){if(animation.isAnimating())animation.stop(targetStyles);return}var settings=this._item.getGrid()._settings.dragPlaceholder;var currentStyles={transform:getTranslateString(currentLeft,currentTop)};animation.start(currentStyles,targetStyles,{duration:settings.duration,easing:settings.easing,onFinish:this._onLayoutEnd})};ItemDragPlaceholder.prototype._onLayoutEnd=function(){if(this._resetAfterLayout){this.reset()}};ItemDragPlaceholder.prototype._onReleaseEnd=function(item){if(item._id===this._item._id){if(!this._animate.isAnimating()){this.reset();return}this._resetAfterLayout=true}};ItemDragPlaceholder.prototype._onMigrate=function(data){if(data.item!==this._item)return;var grid=this._item.getGrid();var nextGrid=data.toGrid;grid.off(eventDragReleaseEnd,this._onReleaseEnd);grid.off(eventLayoutStart,this._onLayoutStart);grid.off(eventBeforeSend,this._onMigrate);nextGrid.on(eventDragReleaseEnd,this._onReleaseEnd);nextGrid.on(eventLayoutStart,this._onLayoutStart);nextGrid.on(eventBeforeSend,this._onMigrate);this._didMigrate=true};ItemDragPlaceholder.prototype.create=function(){if(this.isActive()){this._resetAfterLayout=false;return}var item=this._item;var grid=item.getGrid();var settings=grid._settings;var animation=this._animate;var element;if(isFunction(settings.dragPlaceholder.createElement)){element=settings.dragPlaceholder.createElement(item)}else{element=window.document.createElement("div")}this._element=element;animation._element=element;this._className=settings.itemPlaceholderClass||"";if(this._className){addClass(element,this._className)}var left=item._left+item._marginLeft;var top=item._top+item._marginTop;setStyles(element,{display:"block",position:"absolute",left:"0",top:"0",width:item._width+"px",height:item._height+"px",transform:getTranslateString(left,top)});grid.on(eventLayoutStart,this._onLayoutStart);grid.on(eventDragReleaseEnd,this._onReleaseEnd);grid.on(eventBeforeSend,this._onMigrate);if(isFunction(settings.dragPlaceholder.onCreate)){settings.dragPlaceholder.onCreate(item,element)}grid.getElement().appendChild(element)};ItemDragPlaceholder.prototype.reset=function(){if(!this.isActive())return;var element=this._element;var item=this._item;var grid=item.getGrid();var settings=grid._settings;var animation=this._animate;this._resetAfterLayout=false;cancelPlaceholderTick(item._id);animation.stop();animation._element=null;grid.off(eventDragReleaseEnd,this._onReleaseEnd);grid.off(eventLayoutStart,this._onLayoutStart);grid.off(eventBeforeSend,this._onMigrate);if(this._className){removeClass(element,this._className);this._className=""}element.parentNode.removeChild(element);this._element=null;if(isFunction(settings.dragPlaceholder.onRemove)){settings.dragPlaceholder.onRemove(item,element)}};ItemDragPlaceholder.prototype.updateDimensions=function(width,height){if(this.isActive()){setStyles(this._element,{width:width+"px",height:height+"px"})}};ItemDragPlaceholder.prototype.isActive=function(){return!!this._element};ItemDragPlaceholder.prototype.destroy=function(){this.reset();this._animate.destroy();this._item=this._animate=null};function Queue(){this._queue=[];this._isDestroyed=false}Queue.prototype.add=function(callback){if(this._isDestroyed)return this;this._queue.push(callback);return this};Queue.prototype.flush=function(arg1,arg2){if(this._isDestroyed)return this;var queue=this._queue;var length=queue.length;var i;if(!length)return this;var singleCallback=length===1;var snapshot=singleCallback?queue[0]:queue.slice(0);queue.length=0;if(singleCallback){snapshot(arg1,arg2);return this}for(i=0;i<length;i++){snapshot[i](arg1,arg2);if(this._isDestroyed)break}return this};Queue.prototype.destroy=function(){if(this._isDestroyed)return this;this._isDestroyed=true;this._queue.length=0;return this};function ItemLayout(item){this._item=item;this._isActive=false;this._isDestroyed=false;this._isInterrupted=false;this._currentStyles={};this._targetStyles={};this._currentLeft=0;this._currentTop=0;this._offsetLeft=0;this._offsetTop=0;this._skipNextAnimation=false;this._animateOptions={onFinish:this._finish.bind(this)};this._queue=new Queue;this._setupAnimation=this._setupAnimation.bind(this);this._startAnimation=this._startAnimation.bind(this)}ItemLayout.prototype.start=function(instant,onFinish){if(this._isDestroyed)return;var item=this._item;var element=item._element;var release=item._release;var gridSettings=item.getGrid()._settings;var isPositioning=this._isActive;var isJustReleased=release._isActive&&release._isPositioningStarted===false;var animDuration=isJustReleased?gridSettings.dragReleaseDuration:gridSettings.layoutDuration;var animEasing=isJustReleased?gridSettings.dragReleaseEasing:gridSettings.layoutEasing;var animEnabled=!instant&&!this._skipNextAnimation&&animDuration>0;var isAnimating;if(isPositioning)this._queue.flush(true,item);if(isJustReleased)release._isPositioningStarted=true;if(isFunction(onFinish))this._queue.add(onFinish);if(!animEnabled){this._updateOffsets();this._updateTargetStyles();isAnimating=item._animate.isAnimating();this.stop(false,this._targetStyles);!isAnimating&&setStyles(element,this._targetStyles);this._skipNextAnimation=false;return this._finish()}this._isActive=true;this._animateOptions.easing=animEasing;this._animateOptions.duration=animDuration;this._isInterrupted=isPositioning;addLayoutTick(item._id,this._setupAnimation,this._startAnimation);return this};ItemLayout.prototype.stop=function(processCallbackQueue,targetStyles){if(this._isDestroyed||!this._isActive)return this;var item=this._item;cancelLayoutTick(item._id);item._animate.stop(targetStyles);removeClass(item._element,item.getGrid()._settings.itemPositioningClass);this._isActive=false;if(processCallbackQueue)this._queue.flush(true,item);return this};ItemLayout.prototype.destroy=function(){if(this._isDestroyed)return this;this.stop(true,{});this._queue.destroy();this._item=this._currentStyles=this._targetStyles=this._animateOptions=null;this._isDestroyed=true;return this};ItemLayout.prototype._updateOffsets=function(){if(this._isDestroyed)return;var item=this._item;var migrate=item._migrate;var release=item._release;this._offsetLeft=release._isActive?release._containerDiffX:migrate._isActive?migrate._containerDiffX:0;this._offsetTop=release._isActive?release._containerDiffY:migrate._isActive?migrate._containerDiffY:0};ItemLayout.prototype._updateTargetStyles=function(){if(this._isDestroyed)return;this._targetStyles.transform=getTranslateString(this._item._left+this._offsetLeft,this._item._top+this._offsetTop)};ItemLayout.prototype._finish=function(){if(this._isDestroyed)return;var item=this._item;var migrate=item._migrate;var release=item._release;if(this._isActive){this._isActive=false;removeClass(item._element,item.getGrid()._settings.itemPositioningClass)}if(release._isActive)release.stop();if(migrate._isActive)migrate.stop();this._queue.flush(false,item)};ItemLayout.prototype._setupAnimation=function(){var translate=getTranslate(this._item._element);this._currentLeft=translate.x;this._currentTop=translate.y};ItemLayout.prototype._startAnimation=function(){var item=this._item;var settings=item.getGrid()._settings;this._updateOffsets();this._updateTargetStyles();if(item._left===this._currentLeft-this._offsetLeft&&item._top===this._currentTop-this._offsetTop){if(this._isInterrupted)this.stop(false,this._targetStyles);this._isActive=false;this._finish();return}if(!this._isInterrupted){addClass(item._element,settings.itemPositioningClass)}this._currentStyles.transform=getTranslateString(this._currentLeft,this._currentTop);item._animate.start(this._currentStyles,this._targetStyles,this._animateOptions)};var tempStyles={};function ItemMigrate(item){this._item=item;this._isActive=false;this._isDestroyed=false;this._container=false;this._containerDiffX=0;this._containerDiffY=0}ItemMigrate.prototype.start=function(targetGrid,position,container){if(this._isDestroyed)return this;var item=this._item;var element=item._element;var isVisible=item.isVisible();var grid=item.getGrid();var settings=grid._settings;var targetSettings=targetGrid._settings;var targetElement=targetGrid._element;var targetItems=targetGrid._items;var currentIndex=grid._items.indexOf(item);var targetContainer=container||window.document.body;var targetIndex;var targetItem;var currentContainer;var offsetDiff;var containerDiff;var translate;var translateX;var translateY;if(typeof position==="number"){targetIndex=normalizeArrayIndex(targetItems,position,true)}else{targetItem=targetGrid._getItem(position);if(!targetItem)return this;targetIndex=targetItems.indexOf(targetItem)}if(item.isPositioning()||this._isActive||item.isReleasing()){translate=getTranslate(element);translateX=translate.x;translateY=translate.y}if(item.isPositioning()){item._layout.stop(true,{transform:getTranslateString(translateX,translateY)})}if(this._isActive){translateX-=this._containerDiffX;translateY-=this._containerDiffY;this.stop(true,{transform:getTranslateString(translateX,translateY)})}if(item.isReleasing()){translateX-=item._release._containerDiffX;translateY-=item._release._containerDiffY;item._release.stop(true,{transform:getTranslateString(translateX,translateY)})}item._visibility._stopAnimation();if(item._drag)item._drag.destroy();item._visibility._queue.flush(true,item);if(grid._hasListeners(eventBeforeSend)){grid._emit(eventBeforeSend,{item:item,fromGrid:grid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}if(targetGrid._hasListeners(eventBeforeReceive)){targetGrid._emit(eventBeforeReceive,{item:item,fromGrid:grid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}removeClass(element,settings.itemClass);removeClass(element,settings.itemVisibleClass);removeClass(element,settings.itemHiddenClass);addClass(element,targetSettings.itemClass);addClass(element,isVisible?targetSettings.itemVisibleClass:targetSettings.itemHiddenClass);grid._items.splice(currentIndex,1);arrayInsert(targetItems,item,targetIndex);item._gridId=targetGrid._id;currentContainer=element.parentNode;if(targetContainer!==currentContainer){targetContainer.appendChild(element);offsetDiff=getOffsetDiff(targetContainer,currentContainer,true);if(!translate){translate=getTranslate(element);translateX=translate.x;translateY=translate.y}element.style[transformProp]=getTranslateString(translateX+offsetDiff.left,translateY+offsetDiff.top)}item._child.removeAttribute("style");setStyles(item._child,isVisible?targetSettings.visibleStyles:targetSettings.hiddenStyles);element.style.display=isVisible?"block":"hidden";containerDiff=getOffsetDiff(targetContainer,targetElement,true);item._refreshDimensions();item._refreshSortData();item._drag=targetSettings.dragEnabled?new ItemDrag(item):null;this._isActive=true;this._container=targetContainer;this._containerDiffX=containerDiff.left;this._containerDiffY=containerDiff.top;if(grid._hasListeners(eventSend)){grid._emit(eventSend,{item:item,fromGrid:grid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}if(targetGrid._hasListeners(eventReceive)){targetGrid._emit(eventReceive,{item:item,fromGrid:grid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}return this};ItemMigrate.prototype.stop=function(abort,currentStyles){if(this._isDestroyed||!this._isActive)return this;var item=this._item;var element=item._element;var grid=item.getGrid();var gridElement=grid._element;var translate;if(this._container!==gridElement){if(!currentStyles){if(abort){translate=getTranslate(element);tempStyles.transform=getTranslateString(translate.x-this._containerDiffX,translate.y-this._containerDiffY)}else{tempStyles.transform=getTranslateString(item._left,item._top)}currentStyles=tempStyles}gridElement.appendChild(element);setStyles(element,currentStyles)}this._isActive=false;this._container=null;this._containerDiffX=0;this._containerDiffY=0;return this};ItemMigrate.prototype.destroy=function(){if(this._isDestroyed)return this;this.stop(true);this._item=null;this._isDestroyed=true;return this};var tempStyles$1={};function ItemRelease(item){this._item=item;this._isActive=false;this._isDestroyed=false;this._isPositioningStarted=false;this._containerDiffX=0;this._containerDiffY=0}ItemRelease.prototype.start=function(){if(this._isDestroyed||this._isActive)return this;var item=this._item;var grid=item.getGrid();this._isActive=true;addClass(item._element,grid._settings.itemReleasingClass);grid._emit(eventDragReleaseStart,item);item._layout.start(false);return this};ItemRelease.prototype.stop=function(abort,currentStyles){if(this._isDestroyed||!this._isActive)return this;var item=this._item;var element=item._element;var grid=item.getGrid();var container=grid._element;var translate;this._reset();if(element.parentNode!==container){if(!currentStyles){if(abort){translate=getTranslate(element);tempStyles$1.transform=getTranslateString(translate.x-this._containerDiffX,translate.y-this._containerDiffY)}else{tempStyles$1.transform=getTranslateString(item._left,item._top)}currentStyles=tempStyles$1}container.appendChild(element);setStyles(element,currentStyles)}if(!abort)grid._emit(eventDragReleaseEnd,item);return this};ItemRelease.prototype.destroy=function(){if(this._isDestroyed)return this;this.stop(true);this._item=null;this._isDestroyed=true;return this};ItemRelease.prototype._reset=function(){if(this._isDestroyed)return;var item=this._item;this._isActive=false;this._isPositioningStarted=false;this._containerDiffX=0;this._containerDiffY=0;removeClass(item._element,item.getGrid()._settings.itemReleasingClass)};function getCurrentStyles(element,styles){var current={};for(var prop in styles){current[prop]=getStyle(element,getStyleName(prop))}return current}function ItemVisibility(item){var isActive=item._isActive;var element=item._element;var settings=item.getGrid()._settings;this._item=item;this._isDestroyed=false;this._isHidden=!isActive;this._isHiding=false;this._isShowing=false;this._queue=new Queue;this._finishShow=this._finishShow.bind(this);this._finishHide=this._finishHide.bind(this);element.style.display=isActive?"block":"none";addClass(element,isActive?settings.itemVisibleClass:settings.itemHiddenClass);setStyles(item._child,isActive?settings.visibleStyles:settings.hiddenStyles)}ItemVisibility.prototype.show=function(instant,onFinish){if(this._isDestroyed)return this;var item=this._item;var element=item._element;var queue=this._queue;var callback=isFunction(onFinish)?onFinish:null;var grid=item.getGrid();var settings=grid._settings;if(!this._isShowing&&!this._isHidden){callback&&callback(false,item);return this}if(this._isShowing&&!instant){callback&&queue.add(callback);return this}if(!this._isShowing){queue.flush(true,item);removeClass(element,settings.itemHiddenClass);addClass(element,settings.itemVisibleClass);if(!this._isHiding)element.style.display="block"}callback&&queue.add(callback);item._isActive=this._isShowing=true;this._isHiding=this._isHidden=false;this._startAnimation(true,instant,this._finishShow);return this};ItemVisibility.prototype.hide=function(instant,onFinish){if(this._isDestroyed)return this;var item=this._item;var element=item._element;var queue=this._queue;var callback=isFunction(onFinish)?onFinish:null;var grid=item.getGrid();var settings=grid._settings;if(!this._isHiding&&this._isHidden){callback&&callback(false,item);return this}if(this._isHiding&&!instant){callback&&queue.add(callback);return this}if(!this._isHiding){queue.flush(true,item);addClass(element,settings.itemHiddenClass);removeClass(element,settings.itemVisibleClass)}callback&&queue.add(callback);this._isHidden=this._isHiding=true;item._isActive=this._isShowing=false;this._startAnimation(false,instant,this._finishHide);return this};ItemVisibility.prototype.destroy=function(){if(this._isDestroyed)return this;var item=this._item;var element=item._element;var grid=item.getGrid();var queue=this._queue;var settings=grid._settings;this._stopAnimation({});queue.flush(true,item).destroy();removeClass(element,settings.itemVisibleClass);removeClass(element,settings.itemHiddenClass);this._item=null;this._isHiding=this._isShowing=false;this._isDestroyed=this._isHidden=true;return this};ItemVisibility.prototype._startAnimation=function(toVisible,instant,onFinish){if(this._isDestroyed)return;var item=this._item;var settings=item.getGrid()._settings;var targetStyles=toVisible?settings.visibleStyles:settings.hiddenStyles;var duration=parseInt(toVisible?settings.showDuration:settings.hideDuration)||0;var easing=(toVisible?settings.showEasing:settings.hideEasing)||"ease";var isInstant=instant||duration<=0;var currentStyles;if(!targetStyles){onFinish&&onFinish();return}cancelVisibilityTick(item._id);if(isInstant){if(item._animateChild.isAnimating()){item._animateChild.stop(targetStyles)}else{setStyles(item._child,targetStyles)}onFinish&&onFinish();return}addVisibilityTick(item._id,function(){currentStyles=getCurrentStyles(item._child,targetStyles)},function(){item._animateChild.start(currentStyles,targetStyles,{duration:duration,easing:easing,onFinish:onFinish})})};ItemVisibility.prototype._stopAnimation=function(targetStyles){if(this._isDestroyed)return;var item=this._item;cancelVisibilityTick(item._id);item._animateChild.stop(targetStyles)};ItemVisibility.prototype._finishShow=function(){if(this._isHidden)return;this._isShowing=false;this._queue.flush(false,this._item)};var finishStyles={};ItemVisibility.prototype._finishHide=function(){if(!this._isHidden)return;var item=this._item;this._isHiding=false;finishStyles.transform=getTranslateString(0,0);item._layout.stop(true,finishStyles);item._element.style.display="none";this._queue.flush(false,item)};var id=0;function createUid(){return++id}function Item(grid,element,isActive){var settings=grid._settings;this._id=createUid();this._gridId=grid._id;this._isDestroyed=false;this._left=0;this._top=0;this._element=element;this._child=element.children[0];if(element.parentNode!==grid._element){grid._element.appendChild(element)}addClass(element,settings.itemClass);if(typeof isActive!=="boolean"){isActive=getStyle(element,"display")!=="none"}this._isActive=isActive;element.style.left="0";element.style.top="0";element.style[transformProp]=getTranslateString(0,0);this._animate=new ItemAnimate(element);this._animateChild=new ItemAnimate(this._child);this._visibility=new ItemVisibility(this);this._layout=new ItemLayout(this);this._migrate=new ItemMigrate(this);this._release=new ItemRelease(this);this._dragPlaceholder=new ItemDragPlaceholder(this);this._drag=settings.dragEnabled?new ItemDrag(this):null;this._refreshDimensions();this._refreshSortData()}Item.prototype.getGrid=function(){return gridInstances[this._gridId]};Item.prototype.getElement=function(){return this._element};Item.prototype.getWidth=function(){return this._width};Item.prototype.getHeight=function(){return this._height};Item.prototype.getMargin=function(){return{left:this._marginLeft,right:this._marginRight,top:this._marginTop,bottom:this._marginBottom}};Item.prototype.getPosition=function(){return{left:this._left,top:this._top}};Item.prototype.isActive=function(){return this._isActive};Item.prototype.isVisible=function(){return!!this._visibility&&!this._visibility._isHidden};Item.prototype.isShowing=function(){return!!(this._visibility&&this._visibility._isShowing)};Item.prototype.isHiding=function(){return!!(this._visibility&&this._visibility._isHiding)};Item.prototype.isPositioning=function(){return!!(this._layout&&this._layout._isActive)};Item.prototype.isDragging=function(){return!!(this._drag&&this._drag._isActive)};Item.prototype.isReleasing=function(){return!!(this._release&&this._release._isActive)};Item.prototype.isDestroyed=function(){return this._isDestroyed};Item.prototype._refreshDimensions=function(){if(this._isDestroyed||this._visibility._isHidden)return;var element=this._element;var dragPlaceholder=this._dragPlaceholder;var rect=element.getBoundingClientRect();this._width=rect.width;this._height=rect.height;this._marginLeft=Math.max(0,getStyleAsFloat(element,"margin-left"));this._marginRight=Math.max(0,getStyleAsFloat(element,"margin-right"));this._marginTop=Math.max(0,getStyleAsFloat(element,"margin-top"));this._marginBottom=Math.max(0,getStyleAsFloat(element,"margin-bottom"));if(dragPlaceholder){dragPlaceholder.updateDimensions(this._width,this._height)}};Item.prototype._refreshSortData=function(){if(this._isDestroyed)return;var data=this._sortData={};var getters=this.getGrid()._settings.sortData;var prop;for(prop in getters){data[prop]=getters[prop](this,this._element)}};Item.prototype._destroy=function(removeElement){if(this._isDestroyed)return;var element=this._element;var grid=this.getGrid();var settings=grid._settings;var index=grid._items.indexOf(this);this._release.destroy();this._migrate.destroy();this._layout.destroy();this._visibility.destroy();this._animate.destroy();this._animateChild.destroy();this._dragPlaceholder.destroy();this._drag&&this._drag.destroy();element.removeAttribute("style");this._child.removeAttribute("style");removeClass(element,settings.itemClass);index>-1&&grid._items.splice(index,1);removeElement&&element.parentNode.removeChild(element);this._isActive=false;this._isDestroyed=true};function Packer(){this._slots=[];this._slotSizes=[];this._freeSlots=[];this._newSlots=[];this._rectItem={};this._rectStore=[];this._rectId=0;this._layout={slots:null,setWidth:false,setHeight:false,width:false,height:false};this._sortRectsLeftTop=this._sortRectsLeftTop.bind(this);this._sortRectsTopLeft=this._sortRectsTopLeft.bind(this)}Packer.prototype.getLayout=function(items,width,height,slots,options){var layout=this._layout;var fillGaps=!!(options&&options.fillGaps);var isHorizontal=!!(options&&options.horizontal);var alignRight=!!(options&&options.alignRight);var alignBottom=!!(options&&options.alignBottom);var rounding=!!(options&&options.rounding);var slotSizes=this._slotSizes;var i;layout.slots=slots?slots:this._slots;layout.width=isHorizontal?0:rounding?Math.round(width):width;layout.height=!isHorizontal?0:rounding?Math.round(height):height;layout.setWidth=isHorizontal;layout.setHeight=!isHorizontal;layout.slots.length=0;slotSizes.length=0;if(!items.length)return layout;for(i=0;i<items.length;i++){this._addSlot(items[i],isHorizontal,fillGaps,rounding,alignRight||alignBottom)}if(alignRight){for(i=0;i<layout.slots.length;i=i+2){layout.slots[i]=layout.width-(layout.slots[i]+slotSizes[i])}}if(alignBottom){for(i=1;i<layout.slots.length;i=i+2){layout.slots[i]=layout.height-(layout.slots[i]+slotSizes[i])}}slotSizes.length=0;this._freeSlots.length=0;this._newSlots.length=0;this._rectId=0;return layout};Packer.prototype._addSlot=function(){var eps=.001;var itemSlot={};return function(item,isHorizontal,fillGaps,rounding,trackSize){var layout=this._layout;var freeSlots=this._freeSlots;var newSlots=this._newSlots;var rect;var rectId;var potentialSlots;var ignoreCurrentSlots;var i;var ii;newSlots.length=0;itemSlot.left=null;itemSlot.top=null;itemSlot.width=item._width+item._marginLeft+item._marginRight;itemSlot.height=item._height+item._marginTop+item._marginBottom;if(rounding){itemSlot.width=Math.round(itemSlot.width);itemSlot.height=Math.round(itemSlot.height)}for(i=0;i<freeSlots.length;i++){rectId=freeSlots[i];if(!rectId)continue;rect=this._getRect(rectId);if(itemSlot.width<=rect.width+eps&&itemSlot.height<=rect.height+eps){itemSlot.left=rect.left;itemSlot.top=rect.top;break}}if(itemSlot.left===null){itemSlot.left=!isHorizontal?0:layout.width;itemSlot.top=!isHorizontal?layout.height:0;if(!fillGaps){ignoreCurrentSlots=true}}if(!isHorizontal&&itemSlot.top+itemSlot.height>layout.height){if(itemSlot.left>0){newSlots.push(this._addRect(0,layout.height,itemSlot.left,Infinity))}if(itemSlot.left+itemSlot.width<layout.width){newSlots.push(this._addRect(itemSlot.left+itemSlot.width,layout.height,layout.width-itemSlot.left-itemSlot.width,Infinity))}layout.height=itemSlot.top+itemSlot.height}if(isHorizontal&&itemSlot.left+itemSlot.width>layout.width){if(itemSlot.top>0){newSlots.push(this._addRect(layout.width,0,Infinity,itemSlot.top))}if(itemSlot.top+itemSlot.height<layout.height){newSlots.push(this._addRect(layout.width,itemSlot.top+itemSlot.height,Infinity,layout.height-itemSlot.top-itemSlot.height))}layout.width=itemSlot.left+itemSlot.width}for(i=fillGaps?0:ignoreCurrentSlots?freeSlots.length:i;i<freeSlots.length;i++){rectId=freeSlots[i];if(!rectId)continue;rect=this._getRect(rectId);potentialSlots=this._splitRect(rect,itemSlot);for(ii=0;ii<potentialSlots.length;ii++){rectId=potentialSlots[ii];rect=this._getRect(rectId);if(rect.width>.49&&rect.height>.49&&(!isHorizontal&&rect.top<layout.height||isHorizontal&&rect.left<layout.width)){newSlots.push(rectId)}}}if(newSlots.length){this._purgeRects(newSlots).sort(isHorizontal?this._sortRectsLeftTop:this._sortRectsTopLeft)}if(isHorizontal){layout.width=Math.max(layout.width,itemSlot.left+itemSlot.width)}else{layout.height=Math.max(layout.height,itemSlot.top+itemSlot.height)}layout.slots.push(itemSlot.left,itemSlot.top);if(trackSize)this._slotSizes.push(itemSlot.width,itemSlot.height);this._freeSlots=newSlots;this._newSlots=freeSlots}}();Packer.prototype._addRect=function(left,top,width,height){var rectId=++this._rectId;var rectStore=this._rectStore;rectStore[rectId]=left||0;rectStore[++this._rectId]=top||0;rectStore[++this._rectId]=width||0;rectStore[++this._rectId]=height||0;return rectId};Packer.prototype._getRect=function(id,target){var rectItem=target?target:this._rectItem;var rectStore=this._rectStore;rectItem.left=rectStore[id]||0;rectItem.top=rectStore[++id]||0;rectItem.width=rectStore[++id]||0;rectItem.height=rectStore[++id]||0;return rectItem};Packer.prototype._splitRect=function(){var results=[];return function(rect,hole){results.length=0;if(!this._doRectsOverlap(rect,hole)){results.push(this._addRect(rect.left,rect.top,rect.width,rect.height));return results}if(rect.left<hole.left){results.push(this._addRect(rect.left,rect.top,hole.left-rect.left,rect.height))}if(rect.left+rect.width>hole.left+hole.width){results.push(this._addRect(hole.left+hole.width,rect.top,rect.left+rect.width-(hole.left+hole.width),rect.height))}if(rect.top<hole.top){results.push(this._addRect(rect.left,rect.top,rect.width,hole.top-rect.top))}if(rect.top+rect.height>hole.top+hole.height){results.push(this._addRect(rect.left,hole.top+hole.height,rect.width,rect.top+rect.height-(hole.top+hole.height)))}return results}}();Packer.prototype._doRectsOverlap=function(a,b){return!(a.left+a.width<=b.left||b.left+b.width<=a.left||a.top+a.height<=b.top||b.top+b.height<=a.top)};Packer.prototype._isRectWithinRect=function(a,b){return a.left>=b.left&&a.top>=b.top&&a.left+a.width<=b.left+b.width&&a.top+a.height<=b.top+b.height};Packer.prototype._purgeRects=function(){var rectA={};var rectB={};return function(rectIds){var i=rectIds.length;var ii;while(i--){ii=rectIds.length;if(!rectIds[i])continue;this._getRect(rectIds[i],rectA);while(ii--){if(!rectIds[ii]||i===ii)continue;if(this._isRectWithinRect(rectA,this._getRect(rectIds[ii],rectB))){rectIds[i]=0;break}}}return rectIds}}();Packer.prototype._sortRectsTopLeft=function(){var rectA={};var rectB={};return function(aId,bId){this._getRect(aId,rectA);this._getRect(bId,rectB);return rectA.top<rectB.top?-1:rectA.top>rectB.top?1:rectA.left<rectB.left?-1:rectA.left>rectB.left?1:0}}();Packer.prototype._sortRectsLeftTop=function(){var rectA={};var rectB={};return function(aId,bId){this._getRect(aId,rectA);this._getRect(bId,rectB);return rectA.left<rectB.left?-1:rectA.left>rectB.left?1:rectA.top<rectB.top?-1:rectA.top>rectB.top?1:0}}();var htmlCollectionType="[object HTMLCollection]";var nodeListType="[object NodeList]";function isNodeList(val){var type=Object.prototype.toString.call(val);return type===htmlCollectionType||type===nodeListType}var objectType="object";var objectToStringType="[object Object]";var toString=Object.prototype.toString;function isPlainObject(val){return typeof val===objectType&&toString.call(val)===objectToStringType}function toArray(target){return isNodeList(target)?Array.prototype.slice.call(target):Array.prototype.concat(target)}var packer=new Packer;var noop=function(){};var numberType$1="number";var stringType="string";var instantLayout="instant";function Grid(element,options){var inst=this;var settings;var items;var layoutOnResize;element=this._element=typeof element===stringType?window.document.querySelector(element):element;var isElementInDom=element.getRootNode?element.getRootNode({composed:true})===document:window.document.body.contains(element);if(!isElementInDom||element===window.document.documentElement){throw new Error("Container element must be an existing DOM element")}settings=this._settings=mergeSettings(Grid.defaultOptions,options);if(!isFunction(settings.dragSort)){settings.dragSort=!!settings.dragSort}this._id=createUid();gridInstances[this._id]=inst;this._isDestroyed=false;this._layout={id:0,items:[],slots:[],setWidth:false,setHeight:false,width:0,height:0};this._emitter=new Emitter;addClass(element,settings.containerClass);this._items=[];items=settings.items;if(typeof items===stringType){toArray(element.children).forEach(function(itemElement){if(items==="*"||elementMatches(itemElement,items)){inst._items.push(new Item(inst,itemElement))}})}else if(Array.isArray(items)||isNodeList(items)){this._items=toArray(items).map(function(itemElement){return new Item(inst,itemElement)})}layoutOnResize=settings.layoutOnResize;if(typeof layoutOnResize!==numberType$1){layoutOnResize=layoutOnResize===true?0:-1}if(layoutOnResize>=0){window.addEventListener("resize",inst._resizeHandler=debounce(function(){inst.refreshItems().layout()},layoutOnResize))}if(settings.layoutOnInit){this.layout(true)}}Grid.Item=Item;Grid.ItemLayout=ItemLayout;Grid.ItemVisibility=ItemVisibility;Grid.ItemMigrate=ItemMigrate;Grid.ItemAnimate=ItemAnimate;Grid.ItemDrag=ItemDrag;Grid.ItemRelease=ItemRelease;Grid.ItemDragPlaceholder=ItemDragPlaceholder;Grid.Emitter=Emitter;Grid.Dragger=Dragger;Grid.Packer=Packer;Grid.defaultOptions={items:"*",showDuration:300,showEasing:"ease",hideDuration:300,hideEasing:"ease",visibleStyles:{opacity:"1",transform:"scale(1)"},hiddenStyles:{opacity:"0",transform:"scale(0.5)"},layout:{fillGaps:false,horizontal:false,alignRight:false,alignBottom:false,rounding:true},layoutOnResize:100,layoutOnInit:true,layoutDuration:300,layoutEasing:"ease",sortData:null,dragEnabled:false,dragContainer:null,dragStartPredicate:{distance:0,delay:0,handle:false},dragAxis:null,dragSort:true,dragSortHeuristics:{sortInterval:100,minDragDistance:10,minBounceBackAngle:1},dragSortPredicate:{threshold:50,action:actionMove},dragReleaseDuration:300,dragReleaseEasing:"ease",dragCssProps:{touchAction:"none",userSelect:"none",userDrag:"none",tapHighlightColor:"rgba(0, 0, 0, 0)",touchCallout:"none",contentZooming:"none"},dragPlaceholder:{enabled:false,duration:300,easing:"ease",createElement:null,onCreate:null,onRemove:null},containerClass:"muuri",itemClass:"muuri-item",itemVisibleClass:"muuri-item-shown",itemHiddenClass:"muuri-item-hidden",itemPositioningClass:"muuri-item-positioning",itemDraggingClass:"muuri-item-dragging",itemReleasingClass:"muuri-item-releasing",itemPlaceholderClass:"muuri-item-placeholder"};Grid.prototype.on=function(event,listener){this._emitter.on(event,listener);return this};Grid.prototype.off=function(event,listener){this._emitter.off(event,listener);return this};Grid.prototype.getElement=function(){return this._element};Grid.prototype.getItems=function(targets){if(this._isDestroyed||!targets&&targets!==0){return this._items.slice(0)}var ret=[];var targetItems=toArray(targets);var item;var i;for(i=0;i<targetItems.length;i++){item=this._getItem(targetItems[i]);item&&ret.push(item)}return ret};Grid.prototype.refreshItems=function(items){if(this._isDestroyed)return this;var targets=this.getItems(items);var i;for(i=0;i<targets.length;i++){targets[i]._refreshDimensions()}return this};Grid.prototype.refreshSortData=function(items){if(this._isDestroyed)return this;var targetItems=this.getItems(items);var i;for(i=0;i<targetItems.length;i++){targetItems[i]._refreshSortData()}return this};Grid.prototype.synchronize=function(){if(this._isDestroyed)return this;var container=this._element;var items=this._items;var fragment;var element;var i;if(items.length){for(i=0;i<items.length;i++){element=items[i]._element;if(element.parentNode===container){fragment=fragment||window.document.createDocumentFragment();fragment.appendChild(element)}}if(fragment)container.appendChild(fragment)}this._emit(eventSynchronize);return this};Grid.prototype.layout=function(instant,onFinish){if(this._isDestroyed)return this;var inst=this;var element=this._element;var layout=this._updateLayout();var layoutId=layout.id;var itemsLength=layout.items.length;var counter=itemsLength;var isBorderBox;var item;var i;function tryFinish(){if(--counter>0)return;var hasLayoutChanged=inst._layout.id!==layoutId;var callback=isFunction(instant)?instant:onFinish;if(isFunction(callback)){callback(hasLayoutChanged,layout.items.slice(0))}if(!hasLayoutChanged&&inst._hasListeners(eventLayoutEnd)){inst._emit(eventLayoutEnd,layout.items.slice(0))}}if(layout.setHeight&&typeof layout.height===numberType$1||layout.setWidth&&typeof layout.width===numberType$1){isBorderBox=getStyle(element,"box-sizing")==="border-box"}if(layout.setHeight){if(typeof layout.height===numberType$1){element.style.height=(isBorderBox?layout.height+this._borderTop+this._borderBottom:layout.height)+"px"}else{element.style.height=layout.height}}if(layout.setWidth){if(typeof layout.width===numberType$1){element.style.width=(isBorderBox?layout.width+this._borderLeft+this._borderRight:layout.width)+"px"}else{element.style.width=layout.width}}if(this._hasListeners(eventLayoutStart)){this._emit(eventLayoutStart,layout.items.slice(0))}if(!itemsLength){tryFinish();return this}for(i=0;i<itemsLength;i++){item=layout.items[i];if(!item)continue;item._left=layout.slots[i*2];item._top=layout.slots[i*2+1];item.isDragging()?tryFinish():item._layout.start(instant===true,tryFinish)}return this};Grid.prototype.add=function(elements,options){if(this._isDestroyed||!elements)return[];var newItems=toArray(elements);if(!newItems.length)return newItems;var opts=options||0;var layout=opts.layout?opts.layout:opts.layout===undefined;var items=this._items;var needsLayout=false;var item;var i;for(i=0;i<newItems.length;i++){item=new Item(this,newItems[i],opts.isActive);newItems[i]=item;if(item._isActive){needsLayout=true;item._layout._skipNextAnimation=true}}arrayInsert(items,newItems,opts.index);if(this._hasListeners(eventAdd)){this._emit(eventAdd,newItems.slice(0))}if(needsLayout&&layout){this.layout(layout===instantLayout,isFunction(layout)?layout:undefined)}return newItems};Grid.prototype.remove=function(items,options){if(this._isDestroyed)return this;var opts=options||0;var layout=opts.layout?opts.layout:opts.layout===undefined;var needsLayout=false;var allItems=this.getItems();var targetItems=this.getItems(items);var indices=[];var item;var i;for(i=0;i<targetItems.length;i++){item=targetItems[i];indices.push(allItems.indexOf(item));if(item._isActive)needsLayout=true;item._destroy(opts.removeElements)}if(this._hasListeners(eventRemove)){this._emit(eventRemove,targetItems.slice(0),indices)}if(needsLayout&&layout){this.layout(layout===instantLayout,isFunction(layout)?layout:undefined)}return targetItems};Grid.prototype.show=function(items,options){if(this._isDestroyed)return this;this._setItemsVisibility(items,true,options);return this};Grid.prototype.hide=function(items,options){if(this._isDestroyed)return this;this._setItemsVisibility(items,false,options);return this};Grid.prototype.filter=function(predicate,options){if(this._isDestroyed||!this._items.length)return this;var itemsToShow=[];var itemsToHide=[];var isPredicateString=typeof predicate===stringType;var isPredicateFn=isFunction(predicate);var opts=options||0;var isInstant=opts.instant===true;var layout=opts.layout?opts.layout:opts.layout===undefined;var onFinish=isFunction(opts.onFinish)?opts.onFinish:null;var tryFinishCounter=-1;var tryFinish=noop;var item;var i;if(onFinish){tryFinish=function(){++tryFinishCounter&&onFinish(itemsToShow.slice(0),itemsToHide.slice(0))}}if(isPredicateFn||isPredicateString){for(i=0;i<this._items.length;i++){item=this._items[i];if(isPredicateFn?predicate(item):elementMatches(item._element,predicate)){itemsToShow.push(item)}else{itemsToHide.push(item)}}}if(itemsToShow.length){this.show(itemsToShow,{instant:isInstant,onFinish:tryFinish,layout:false})}else{tryFinish()}if(itemsToHide.length){this.hide(itemsToHide,{instant:isInstant,onFinish:tryFinish,layout:false})}else{tryFinish()}if(itemsToShow.length||itemsToHide.length){if(this._hasListeners(eventFilter)){this._emit(eventFilter,itemsToShow.slice(0),itemsToHide.slice(0))}if(layout){this.layout(layout===instantLayout,isFunction(layout)?layout:undefined)}}return this};Grid.prototype.sort=function(){var sortComparer;var isDescending;var origItems;var indexMap;function parseCriteria(data){return data.trim().split(" ").map(function(val){return val.split(":")})}function getIndexMap(items){var ret={};for(var i=0;i<items.length;i++){ret[items[i]._id]=i}return ret}function compareIndices(itemA,itemB){var indexA=indexMap[itemA._id];var indexB=indexMap[itemB._id];return isDescending?indexB-indexA:indexA-indexB}function defaultComparer(a,b){var result=0;var criteriaName;var criteriaOrder;var valA;var valB;for(var i=0;i<sortComparer.length;i++){criteriaName=sortComparer[i][0];criteriaOrder=sortComparer[i][1];valA=(a._sortData?a:a._refreshSortData())._sortData[criteriaName];valB=(b._sortData?b:b._refreshSortData())._sortData[criteriaName];if(criteriaOrder==="desc"||!criteriaOrder&&isDescending){result=valB<valA?-1:valB>valA?1:0}else{result=valA<valB?-1:valA>valB?1:0}if(result)return result}if(!result){if(!indexMap)indexMap=getIndexMap(origItems);result=compareIndices(a,b)}return result}function customComparer(a,b){var result=sortComparer(a,b);if(isDescending&&result)result=-result;if(result)return result;if(!indexMap)indexMap=getIndexMap(origItems);return compareIndices(a,b)}return function(comparer,options){if(this._isDestroyed||this._items.length<2)return this;var items=this._items;var opts=options||0;var layout=opts.layout?opts.layout:opts.layout===undefined;var i;sortComparer=comparer;isDescending=!!opts.descending;origItems=items.slice(0);indexMap=null;if(isFunction(sortComparer)){items.sort(customComparer)}else if(typeof sortComparer===stringType){sortComparer=parseCriteria(comparer);items.sort(defaultComparer)}else if(Array.isArray(sortComparer)){if(sortComparer.length!==items.length){throw new Error("["+namespace+"] sort reference items do not match with grid items.")}for(i=0;i<items.length;i++){if(sortComparer.indexOf(items[i])<0){throw new Error("["+namespace+"] sort reference items do not match with grid items.")}items[i]=sortComparer[i]}if(isDescending)items.reverse()}else{return this}if(this._hasListeners(eventSort)){this._emit(eventSort,items.slice(0),origItems)}if(layout){this.layout(layout===instantLayout,isFunction(layout)?layout:undefined)}return this}}();Grid.prototype.move=function(item,position,options){if(this._isDestroyed||this._items.length<2)return this;var items=this._items;var opts=options||0;var layout=opts.layout?opts.layout:opts.layout===undefined;var isSwap=opts.action===actionSwap;var action=isSwap?actionSwap:actionMove;var fromItem=this._getItem(item);var toItem=this._getItem(position);var fromIndex;var toIndex;if(fromItem&&toItem&&fromItem!==toItem){fromIndex=items.indexOf(fromItem);toIndex=items.indexOf(toItem);if(isSwap){arraySwap(items,fromIndex,toIndex)}else{arrayMove(items,fromIndex,toIndex)}if(this._hasListeners(eventMove)){this._emit(eventMove,{item:fromItem,fromIndex:fromIndex,toIndex:toIndex,action:action})}if(layout){this.layout(layout===instantLayout,isFunction(layout)?layout:undefined)}}return this};Grid.prototype.send=function(item,grid,position,options){if(this._isDestroyed||grid._isDestroyed||this===grid)return this;item=this._getItem(item);if(!item)return this;var opts=options||0;var container=opts.appendTo||window.document.body;var layoutSender=opts.layoutSender?opts.layoutSender:opts.layoutSender===undefined;var layoutReceiver=opts.layoutReceiver?opts.layoutReceiver:opts.layoutReceiver===undefined;item._migrate.start(grid,position,container);if(item._migrate._isActive&&item._isActive){if(layoutSender){this.layout(layoutSender===instantLayout,isFunction(layoutSender)?layoutSender:undefined)}if(layoutReceiver){grid.layout(layoutReceiver===instantLayout,isFunction(layoutReceiver)?layoutReceiver:undefined)}}return this};Grid.prototype.destroy=function(removeElements){if(this._isDestroyed)return this;var container=this._element;var items=this._items.slice(0);var i;if(this._resizeHandler){window.removeEventListener("resize",this._resizeHandler)}for(i=0;i<items.length;i++){items[i]._destroy(removeElements)}removeClass(container,this._settings.containerClass);container.style.height="";container.style.width="";this._emit(eventDestroy);this._emitter.destroy();gridInstances[this._id]=undefined;this._isDestroyed=true;return this};Grid.prototype._getItem=function(target){if(this._isDestroyed||!target&&target!==0){return null}if(typeof target===numberType$1){return this._items[target>-1?target:this._items.length+target]||null}if(target instanceof Item){return target._gridId===this._id?target:null}for(var i=0;i<this._items.length;i++){if(this._items[i]._element===target){return this._items[i]}}return null};Grid.prototype._updateLayout=function(){var layout=this._layout;var settings=this._settings.layout;var width;var height;var newLayout;var i;++layout.id;layout.items.length=0;for(i=0;i<this._items.length;i++){if(this._items[i]._isActive)layout.items.push(this._items[i])}this._refreshDimensions();width=this._width-this._borderLeft-this._borderRight;height=this._height-this._borderTop-this._borderBottom;if(isFunction(settings)){newLayout=settings(layout.items,width,height)}else{newLayout=packer.getLayout(layout.items,width,height,layout.slots,settings)}layout.slots=newLayout.slots;layout.setWidth=Boolean(newLayout.setWidth);layout.setHeight=Boolean(newLayout.setHeight);layout.width=newLayout.width;layout.height=newLayout.height;return layout};Grid.prototype._emit=function(){if(this._isDestroyed)return;this._emitter.emit.apply(this._emitter,arguments)};Grid.prototype._hasListeners=function(event){var listeners=this._emitter._events[event];return!!(listeners&&listeners.length)};Grid.prototype._updateBoundingRect=function(){var element=this._element;var rect=element.getBoundingClientRect();this._width=rect.width;this._height=rect.height;this._left=rect.left;this._top=rect.top};Grid.prototype._updateBorders=function(left,right,top,bottom){var element=this._element;if(left)this._borderLeft=getStyleAsFloat(element,"border-left-width");if(right)this._borderRight=getStyleAsFloat(element,"border-right-width");if(top)this._borderTop=getStyleAsFloat(element,"border-top-width");if(bottom)this._borderBottom=getStyleAsFloat(element,"border-bottom-width")};Grid.prototype._refreshDimensions=function(){this._updateBoundingRect();this._updateBorders(1,1,1,1)};Grid.prototype._setItemsVisibility=function(items,toVisible,options){var grid=this;var targetItems=this.getItems(items);var opts=options||0;var isInstant=opts.instant===true;var callback=opts.onFinish;var layout=opts.layout?opts.layout:opts.layout===undefined;var counter=targetItems.length;var startEvent=toVisible?eventShowStart:eventHideStart;var endEvent=toVisible?eventShowEnd:eventHideEnd;var method=toVisible?"show":"hide";var needsLayout=false;var completedItems=[];var hiddenItems=[];var item;var i;if(!counter){if(isFunction(callback))callback(targetItems);return}if(this._hasListeners(startEvent)){this._emit(startEvent,targetItems.slice(0))}for(i=0;i<targetItems.length;i++){item=targetItems[i];if(toVisible&&!item._isActive||!toVisible&&item._isActive){needsLayout=true}if(toVisible&&!item._isActive){item._layout._skipNextAnimation=true}if(toVisible&&item._visibility._isHidden){hiddenItems.push(item)}item._visibility[method](isInstant,function(interrupted,item){if(!interrupted)completedItems.push(item);if(--counter<1){if(isFunction(callback))callback(completedItems.slice(0));if(grid._hasListeners(endEvent))grid._emit(endEvent,completedItems.slice(0))}})}if(hiddenItems.length)this.refreshItems(hiddenItems);if(needsLayout&&layout){this.layout(layout===instantLayout,isFunction(layout)?layout:undefined)}};function mergeSettings(defaultSettings,userSettings){var ret=mergeObjects({},defaultSettings);if(userSettings){ret=mergeObjects(ret,userSettings)}ret.visibleStyles=(userSettings||0).visibleStyles||(defaultSettings||0).visibleStyles;ret.hiddenStyles=(userSettings||0).hiddenStyles||(defaultSettings||0).hiddenStyles;return ret}function mergeObjects(target,source){var sourceKeys=Object.keys(source);var length=sourceKeys.length;var isSourceObject;var propName;var i;for(i=0;i<length;i++){propName=sourceKeys[i];isSourceObject=isPlainObject(source[propName]);if(isPlainObject(target[propName])&&isSourceObject){target[propName]=mergeObjects(mergeObjects({},target[propName]),source[propName]);continue}if(isSourceObject){target[propName]=mergeObjects({},source[propName]);continue}if(Array.isArray(source[propName])){target[propName]=source[propName].slice(0);continue}target[propName]=source[propName]}return target}return Grid});